﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.IO;
using gov.va.med.VBECS.Communication.Common;
using gov.va.med.VBECS.Communication.Utils;

namespace ClientDemo.Utils
{
    class FileMessageFactory : IMessageFactory
    {
        public IMessage ReadMesage(string configValue)
        {
            string filename = null;
            try
            {
                filename = ConfigurationManager.AppSettings.Get(configValue);
            }
            // ReSharper disable EmptyGeneralCatchClause
            catch { }
            // ReSharper restore EmptyGeneralCatchClause

            IMessage message;
            if (filename == null)
            {
                Console.Write("Write some message to be sent to server: ");
                message = new TextMessage(Console.ReadLine()); //Get a message from user
            }
            else
            {
                Console.Write("Deserialize message from the file: " + filename);
                IMessageSerializer sr = new TextMessageSerializer();

                try
                {
                    message = sr.DeSerializeObject(filename);
                }
                catch (Exception exception)
                {
                    Console.Write("Error reading message from file: " + exception.Message);
                    return null;
                }
            }
            return message;
        }

        public IList<IMessage> ReadMesages(string configValue)
        {
            var msg = ReadMesage(configValue);
            if(msg != null)
                return new List<IMessage> { msg };

            string filename = null;
            try
            {
                filename = ConfigurationManager.AppSettings.Get(configValue);
            }
            // ReSharper disable EmptyGeneralCatchClause
            catch { }
            // ReSharper restore EmptyGeneralCatchClause
            var counter = 0;
            IList<IMessage> messages = new List<IMessage>();
            while (true)
            {
                if (!File.Exists(filename + counter + ".txt"))
                {
                    Console.Write("file doesn't exists: " + filename + counter + ".txt");
                    Console.Write("Exist");
                    return messages;
                }

                Console.Write("Deserialize message from the file: " + filename + counter + ".txt");
                IMessageSerializer sr = new TextMessageSerializer();
                messages.Add(sr.DeSerializeObject(filename + counter++ + ".txt"));
            }
        }
    }
}
